/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWUserInfo;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.apps.designer.VWIDMLocalSaveOptionDialog;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.toolkit.design.palette.VWBaseStepPalettePanel;
import filenet.vw.toolkit.design.palette.VWModelessPaletteDialog;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.design.palette.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VWStepPaletteDocumentHelper {
    private static final Dimension DIM_SAVE_DIALOG = new Dimension(500, 200);
    private static final String PALETTE_NAME_BASE_PATH = "filenet/vw/toolkit/design/palette/predefinedsteps/";
    private static final String PALETTE_NAME_P8_BPM = "standard_p8_step_palette";
    private static final String PALETTE_NAME_IM_BPM = "standard_im_step_palette";
    private static final String PALETTE_NAME_CHECKPOINT = "checkpoint_step_palette";
    private static final String PALETTE_NAME_GENERAL_SYSTEM = "general_system_step_palette";
    private static final String PALETTE_NAME_TIMER = "timer_step_palette";
    private static final String PALETTE_NAME_WEB_SERVICES = "web_service_step_palette";
    private static final String DIAGRAM_PALETTE_NAME = "diagram_step_palette";
    private static final int PALETTE_ID_BPM = 1;
    private static final int PALETTE_ID_CHECKPOINT = 2;
    private static final int PALETTE_ID_GENERAL_SYSTEM = 4;
    private static final int PALETTE_ID_TIMER = 8;
    private static final int PALETTE_ID_WEB_SERVICES = 16;
    private static final int PALETTE_ID_MY_PALETTE = 32;
    private VWDesignerCoreData m_designerCoreData = null;
    private VWStepPaletteWrapper[] m_stepPalettes = null;
    private VWStepPaletteWrapper m_diagramStepPalette = null;
    private FileDialog m_saveFileDialog = null;
    private FileDialog m_openFileDialog = null;
    private VWModelessPaletteDialog m_paletteDialog = null;
    private IVWIDMItem m_IDMContext = null;

    public VWStepPaletteDocumentHelper(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
        try {
            this.m_saveFileDialog = new FileDialog(this.m_designerCoreData.getParentFrame());
            this.m_saveFileDialog.setMode(1);
            this.m_saveFileDialog.setTitle(VWResource.s_saveStr);
            this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
            this.m_openFileDialog = new FileDialog(this.m_designerCoreData.getParentFrame());
            this.m_openFileDialog.setMode(0);
            this.m_openFileDialog.setTitle(VWResource.s_openStr);
            this.m_openFileDialog.setFile(VWResource.s_fileOpenFilterName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWStepPaletteWrapper getDiagramStepPalette() {
        if (this.m_diagramStepPalette == null) {
            this.m_diagramStepPalette = this.loadDiagramStepPalette();
        }
        return this.m_diagramStepPalette;
    }

    public String getSavedFileName() {
        VWStepPaletteWrapper vwStepPaletteWrapper = this.findStepPalette(VWResource.s_myPaletteOption);
        if (vwStepPaletteWrapper != null) {
            return vwStepPaletteWrapper.getFileNameToolTip();
        }
        return null;
    }

    public boolean saveChanges() {
        VWStepPaletteWrapper vwStepPaletteWrapper = this.findStepPalette(VWResource.s_myPaletteOption);
        if (vwStepPaletteWrapper != null) {
            boolean bContinue = this.tryToSaveStepPalette(vwStepPaletteWrapper);
            if (bContinue && this.m_paletteDialog != null) {
                this.m_paletteDialog.setVisible(false);
            }
            return bContinue;
        }
        return true;
    }

    public void releaseReferences() {
        this.m_designerCoreData = null;
        this.m_stepPalettes = null;
        this.m_diagramStepPalette = null;
        this.m_saveFileDialog = null;
        this.m_openFileDialog = null;
        if (this.m_paletteDialog != null) {
            this.m_paletteDialog.releaseReferences();
            this.m_paletteDialog = null;
        }
        this.m_IDMContext = null;
    }

    protected VWStepPaletteWrapper[] getStepPalettes() {
        if (this.m_stepPalettes == null) {
            Vector<String> paletteFileNameList = new Vector<String>();
            boolean bDisplayP8Palettes = this.m_designerCoreData.getSessionInfo().getDisplayP8BPMFunctionality();
            if (bDisplayP8Palettes) {
                paletteFileNameList.addElement("filenet/vw/toolkit/design/palette/predefinedsteps/standard_p8_step_palette");
            } else {
                paletteFileNameList.addElement("filenet/vw/toolkit/design/palette/predefinedsteps/standard_im_step_palette");
            }
            paletteFileNameList.addElement("filenet/vw/toolkit/design/palette/predefinedsteps/checkpoint_step_palette");
            paletteFileNameList.addElement("filenet/vw/toolkit/design/palette/predefinedsteps/general_system_step_palette");
            paletteFileNameList.addElement("filenet/vw/toolkit/design/palette/predefinedsteps/timer_step_palette");
            if (bDisplayP8Palettes) {
                paletteFileNameList.addElement("filenet/vw/toolkit/design/palette/predefinedsteps/web_service_step_palette");
            }
            Object[] stepPaletteNames = new String[paletteFileNameList.size()];
            paletteFileNameList.copyInto(stepPaletteNames);
            Vector<VWStepPaletteWrapper> stepPaletteList = new Vector<VWStepPaletteWrapper>();
            Vector<VWStepPaletteWrapper> loadedPalettes = this.loadStepPalettes((String[])stepPaletteNames, 0);
            if (loadedPalettes != null) {
                stepPaletteList.addAll(loadedPalettes);
            }
            if ((loadedPalettes = this.loadStepPalettes((String[])(stepPaletteNames = this.m_designerCoreData.getSessionInfo().getPublishedStepPaletteNames()), 2)) != null) {
                stepPaletteList.addAll(loadedPalettes);
            }
            VWStepPaletteWrapper vwStepPaletteWrapper = new VWStepPaletteWrapper(1, null, this.m_designerCoreData);
            stepPaletteList.addElement(vwStepPaletteWrapper);
            if (stepPaletteList.size() > 0) {
                this.m_stepPalettes = new VWStepPaletteWrapper[stepPaletteList.size()];
                stepPaletteList.copyInto(this.m_stepPalettes);
            }
            if (this.openLastStepPalette(vwStepPaletteWrapper)) {
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                this.m_openFileDialog.setFile(vwStepPaletteWrapper.getFileName());
                this.m_openFileDialog.setDirectory(vwStepPaletteWrapper.getFileNameToolTip());
                this.m_saveFileDialog.setFile(vwStepPaletteWrapper.getFileName());
                this.m_saveFileDialog.setDirectory(vwStepPaletteWrapper.getFileNameToolTip());
            }
        }
        if (this.m_stepPalettes != null && this.m_stepPalettes.length > 0) {
            VWStepPaletteWrapper[] stepPalettes = new VWStepPaletteWrapper[this.m_stepPalettes.length];
            System.arraycopy(this.m_stepPalettes, 0, stepPalettes, 0, this.m_stepPalettes.length);
            return stepPalettes;
        }
        return null;
    }

    protected void displayStepPaletteDialog(boolean bShow, VWBaseStepPalettePanel stepPalettePanel, VWStepPaletteWrapper[] stepPaletteWrappers) {
        if (this.m_paletteDialog == null) {
            this.m_paletteDialog = new VWModelessPaletteDialog(this.m_designerCoreData);
        }
        if (bShow && !this.m_paletteDialog.isVisible()) {
            this.m_paletteDialog.setStepPalettePanel(stepPalettePanel);
            this.m_paletteDialog.applyComponentOrientation(stepPalettePanel.m_iconViewPanel.getComponentOrientation());
            this.m_paletteDialog.displayPalettes(stepPaletteWrappers);
        }
        this.m_paletteDialog.setVisible(bShow);
    }

    protected void updateStepPaletteDialog(VWBaseStepPalettePanel stepPalettePanel, VWStepPaletteWrapper[] stepPaletteWrappers) {
        if (this.m_paletteDialog == null || !this.m_paletteDialog.isVisible()) {
            return;
        }
        this.m_paletteDialog.setStepPalettePanel(stepPalettePanel);
        this.m_paletteDialog.displayPalettes(stepPaletteWrappers);
    }

    protected void performNewItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        if (vwStepPaletteWrapper != null && this.tryToSaveStepPalette(vwStepPaletteWrapper)) {
            try {
                vwStepPaletteWrapper.loadStepPaletteFromFile(VWResource.s_fileSaveFilterName);
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                this.m_openFileDialog.setFile(VWResource.s_fileOpenFilterName);
                this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    protected void performOpenItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        if (vwStepPaletteWrapper != null && this.tryToSaveStepPalette(vwStepPaletteWrapper)) {
            this.m_openFileDialog.setVisible(true);
            String fileToOpen = this.m_openFileDialog.getFile();
            if (fileToOpen != null) {
                this.openLocalFile(this.m_openFileDialog.getDirectory() + fileToOpen, vwStepPaletteWrapper);
            }
        }
    }

    protected boolean performSaveItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        try {
            if (vwStepPaletteWrapper.checkInOrCancelCheckOut(this.m_designerCoreData.getParentFrame(), VWResource.s_cancelCheckout)) {
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                if (this.m_saveFileDialog.getFile() == null || this.m_saveFileDialog.getFile() == VWResource.s_fileSaveFilterName) {
                    return this.performSaveAsItemAction(vwStepPaletteWrapper);
                }
                return this.saveStepPaletteToLocalFile(vwStepPaletteWrapper);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileSaveErrorTitle, 1);
        }
        return false;
    }

    protected boolean performSaveAsItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        block3: {
            try {
                if (!vwStepPaletteWrapper.checkInOrCancelCheckOut(this.m_designerCoreData.getParentFrame(), VWResource.s_cancelCheckout)) break block3;
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                String savedDir = this.m_saveFileDialog.getDirectory();
                String savedFile = this.m_saveFileDialog.getFile();
                this.m_saveFileDialog.setVisible(true);
                if (this.m_saveFileDialog.getFile() == null) {
                    this.m_saveFileDialog.setDirectory(savedDir);
                    this.m_saveFileDialog.setFile(savedFile);
                    break block3;
                }
                return this.saveStepPaletteToLocalFile(vwStepPaletteWrapper);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileSaveErrorTitle, 1);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFnOpenItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        try {
            block5: {
                try {
                    if (!this.tryToSaveStepPalette(vwStepPaletteWrapper)) break block5;
                    this.m_designerCoreData.displayWaitCursor();
                    if (!vwStepPaletteWrapper.browseAndopenFileNetDocument(this.m_IDMContext)) break block5;
                    this.m_IDMContext = vwStepPaletteWrapper.getIDMDocument();
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                    if (VWStringUtils.compare(vwStepPaletteWrapper.getName(), VWResource.s_myPaletteOption) == 0) {
                        this.updateSavedStepPaletteFilePath(vwStepPaletteWrapper.getCanonicalName());
                    }
                    this.m_openFileDialog.setFile(VWResource.s_fileOpenFilterName);
                    this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fnOpenErrTitle, 1);
                    Object var4_3 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                }
            }
            Object var4_2 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performFnAddItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        block8: {
            boolean bl;
            try {
                try {
                    this.m_designerCoreData.displayWaitCursor();
                    if (vwStepPaletteWrapper == null) break block8;
                    if (vwStepPaletteWrapper.addFileNetDocument(this.m_designerCoreData.getParentFrame(), this.m_IDMContext)) {
                        this.m_IDMContext = vwStepPaletteWrapper.getIDMDocument();
                        this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                        if (VWStringUtils.compare(vwStepPaletteWrapper.getName(), VWResource.s_myPaletteOption) == 0) {
                            this.updateSavedStepPaletteFilePath(vwStepPaletteWrapper.getCanonicalName());
                        }
                        this.m_openFileDialog.setFile(VWResource.s_fileOpenFilterName);
                        this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
                        boolean bl2 = true;
                        Object var4_5 = null;
                        this.m_designerCoreData.restoreDefaultCursor();
                        return bl2;
                    }
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                    bl = false;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fnAddErrTitle, 1);
                    Object var4_8 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                throw throwable;
            }
            Object var4_6 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            return bl;
        }
        Object var4_7 = null;
        this.m_designerCoreData.restoreDefaultCursor();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFnCheckInItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        try {
            block4: {
                try {
                    this.m_designerCoreData.displayWaitCursor();
                    if (vwStepPaletteWrapper == null || !vwStepPaletteWrapper.checkInFileNetDocument(this.m_designerCoreData.getParentFrame())) break block4;
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fnCheckInErrTitle, 1);
                    Object var4_3 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                }
            }
            Object var4_2 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFnCancelCheckOutItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        try {
            block4: {
                try {
                    this.m_designerCoreData.displayWaitCursor();
                    if (vwStepPaletteWrapper == null) break block4;
                    vwStepPaletteWrapper.cancelFileNetDocumentCheckOut();
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fnCancelCheckoutErrTitle, 1);
                    Object var4_3 = null;
                    this.m_designerCoreData.restoreDefaultCursor();
                }
            }
            Object var4_2 = null;
            this.m_designerCoreData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performFnSaveItemAction(VWStepPaletteWrapper vwStepPaletteWrapper) {
        try {
            this.m_designerCoreData.displayWaitCursor();
            if (vwStepPaletteWrapper != null) {
                vwStepPaletteWrapper.saveCheckedOutFileNetDocument();
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
            }
            boolean bl = true;
            Object var4_4 = null;
            this.m_designerCoreData.restoreDefaultCursor();
            return bl;
        }
        catch (Exception ex) {
            try {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fnSaveErrTitle, 1);
                Object var4_5 = null;
                this.m_designerCoreData.restoreDefaultCursor();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                throw throwable;
            }
        }
        return false;
    }

    protected String[] getSelectedStepPaletteResourceNames() {
        try {
            VWUserInfo userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                Vector<String> resourceNameList = new Vector<String>();
                boolean bDisplayP8Palettes = this.m_designerCoreData.getSessionInfo().getDisplayP8BPMFunctionality();
                Integer bitMask = (Integer)userInfo.getFieldValue("step_palette_selected_palettes");
                if (bitMask != null) {
                    int nBitMask = bitMask;
                    if ((nBitMask & 1) == 1) {
                        if (bDisplayP8Palettes) {
                            resourceNameList.addElement(PALETTE_NAME_P8_BPM);
                        } else {
                            resourceNameList.addElement(PALETTE_NAME_IM_BPM);
                        }
                    }
                    if ((nBitMask & 2) == 2) {
                        resourceNameList.addElement(PALETTE_NAME_CHECKPOINT);
                    }
                    if ((nBitMask & 4) == 4) {
                        resourceNameList.addElement(PALETTE_NAME_GENERAL_SYSTEM);
                    }
                    if ((nBitMask & 8) == 8) {
                        resourceNameList.addElement(PALETTE_NAME_TIMER);
                    }
                    if ((nBitMask & 0x10) == 16) {
                        resourceNameList.addElement(PALETTE_NAME_WEB_SERVICES);
                    }
                    if ((nBitMask & 0x20) == 32) {
                        resourceNameList.addElement(VWResource.s_myPaletteOption);
                    }
                }
                if (resourceNameList.size() == 0) {
                    if (bDisplayP8Palettes) {
                        resourceNameList.addElement(PALETTE_NAME_P8_BPM);
                    } else {
                        resourceNameList.addElement(PALETTE_NAME_IM_BPM);
                    }
                }
                Object[] resourceNames = new String[resourceNameList.size()];
                resourceNameList.copyInto(resourceNames);
                return resourceNames;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected void setSelectedStepPalettes(VWStepPaletteWrapper[] selectedStepPalettes) {
        try {
            VWUserInfo userInfo;
            if (this.m_paletteDialog != null && this.m_paletteDialog.isVisible()) {
                this.m_paletteDialog.displayPalettes(selectedStepPalettes);
            }
            if ((userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo()) != null) {
                int nBitMask = 0;
                if (selectedStepPalettes != null) {
                    for (int nIndex = 0; nIndex < selectedStepPalettes.length; ++nIndex) {
                        String resourceName = selectedStepPalettes[nIndex].getResourceName();
                        if (VWStringUtils.compare(resourceName, PALETTE_NAME_P8_BPM) == 0) {
                            nBitMask |= 1;
                            continue;
                        }
                        if (VWStringUtils.compare(resourceName, PALETTE_NAME_IM_BPM) == 0) {
                            nBitMask |= 1;
                            continue;
                        }
                        if (VWStringUtils.compare(resourceName, PALETTE_NAME_CHECKPOINT) == 0) {
                            nBitMask |= 2;
                            continue;
                        }
                        if (VWStringUtils.compare(resourceName, PALETTE_NAME_GENERAL_SYSTEM) == 0) {
                            nBitMask |= 4;
                            continue;
                        }
                        if (VWStringUtils.compare(resourceName, PALETTE_NAME_TIMER) == 0) {
                            nBitMask |= 8;
                            continue;
                        }
                        if (VWStringUtils.compare(resourceName, PALETTE_NAME_WEB_SERVICES) == 0) {
                            nBitMask |= 0x10;
                            continue;
                        }
                        if (selectedStepPalettes[nIndex].getType() != 1) continue;
                        nBitMask |= 0x20;
                    }
                }
                userInfo.setFieldValue("step_palette_selected_palettes", nBitMask);
                userInfo.save();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWStepPaletteWrapper loadDiagramStepPalette() {
        try {
            String[] stepPaletteNames = new String[]{"filenet/vw/toolkit/design/palette/predefinedsteps/diagram_step_palette"};
            Vector<VWStepPaletteWrapper> loadedStepPaletteList = this.loadStepPalettes(stepPaletteNames, 0);
            if (loadedStepPaletteList != null && loadedStepPaletteList.size() > 0) {
                return loadedStepPaletteList.elementAt(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private Vector<VWStepPaletteWrapper> loadStepPalettes(String[] stepPaletteNames, int nType) {
        try {
            if (stepPaletteNames == null || stepPaletteNames.length == 0) {
                return null;
            }
            Vector<VWStepPaletteWrapper> stepPalettes = new Vector<VWStepPaletteWrapper>();
            ClassLoader externalClassLoader = this.m_designerCoreData.getSessionInfo().getExternalClassLoader();
            for (int nIndex = 0; nIndex < stepPaletteNames.length; ++nIndex) {
                try {
                    InputStream inStream;
                    String resourceName = stepPaletteNames[nIndex];
                    if (resourceName == null || resourceName.length() <= 0 || (inStream = this.getPaletteResourceAsStream(externalClassLoader, resourceName)) == null) continue;
                    VWStepPaletteWrapper vwStepPaletteWrapper = new VWStepPaletteWrapper(nType, resourceName, this.m_designerCoreData);
                    vwStepPaletteWrapper.loadStepPaletteFromStream(inStream);
                    inStream.close();
                    stepPalettes.addElement(vwStepPaletteWrapper);
                    continue;
                }
                catch (Exception ex1) {
                    VWDebug.logException(ex1);
                }
            }
            return stepPalettes;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private InputStream getPaletteResourceAsStream(ClassLoader classLoader, String filePath) {
        InputStream inStream;
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        if (language != null && language.equalsIgnoreCase("iw")) {
            language = "he";
        }
        if ((inStream = classLoader.getResourceAsStream(filePath + "_" + language + "_" + locale.getCountry() + ".xml")) == null) {
            if (language != null && language.equalsIgnoreCase("nb") || language != null && language.equalsIgnoreCase("NO")) {
                language = "nb_NO";
            }
            inStream = classLoader.getResourceAsStream(filePath + "_" + language + ".xml");
        }
        if (inStream == null) {
            inStream = classLoader.getResourceAsStream(filePath + "_en_US.xml");
        }
        if (inStream == null) {
            System.out.println("[WARNING] Could not find " + filePath + " palette file! Locale = " + locale);
        }
        return inStream;
    }

    private boolean openLastStepPalette(VWStepPaletteWrapper vwStepPaletteWrapper) {
        String filePath = this.getSavedFilePath();
        if (filePath != null && filePath.length() > 0) {
            try {
                VWAttachment vwAttachment = new VWAttachment(filePath);
                if (vwAttachment != null) {
                    boolean bSuccessful = vwStepPaletteWrapper.openFileNetDocument(this.m_designerCoreData.getParentFrame(), vwAttachment);
                    if (!bSuccessful) {
                        this.updateSavedStepPaletteFilePath(null);
                    }
                    return bSuccessful;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                File paletteFile = new File(filePath);
                if (paletteFile != null && paletteFile.exists()) {
                    vwStepPaletteWrapper.loadStepPaletteFromFile(filePath);
                    return true;
                }
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_fileNotFound.toString(filePath), VWResource.s_fileOpenErrorTitle, 1);
                this.updateSavedStepPaletteFilePath(null);
            }
            catch (Exception ex) {
                VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileOpenErrorTitle, 1);
                this.updateSavedStepPaletteFilePath(null);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openLocalFile(String filePath, VWStepPaletteWrapper vwStepPaletteWrapper) {
        block11: {
            try {
                block10: {
                    try {
                        if (filePath == null) {
                            Object var5_3 = null;
                            break block10;
                        }
                        this.m_designerCoreData.displayWaitCursor();
                        vwStepPaletteWrapper.loadStepPaletteFromFile(filePath);
                        this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
                        int nIndex = filePath.lastIndexOf("\\");
                        if (nIndex == -1) {
                            this.m_saveFileDialog.setDirectory("");
                            this.m_saveFileDialog.setFile(filePath);
                        } else {
                            this.m_saveFileDialog.setDirectory(filePath.substring(0, nIndex) + "\\");
                            this.m_saveFileDialog.setFile(filePath.substring(nIndex + 1, filePath.length()));
                        }
                        if (VWStringUtils.compare(vwStepPaletteWrapper.getName(), VWResource.s_myPaletteOption) == 0) {
                            this.updateSavedStepPaletteFilePath(filePath);
                        }
                        break block11;
                    }
                    catch (SecurityException ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileSecurityErrorTitle, 1);
                        this.performNewItemAction(vwStepPaletteWrapper);
                        Object var5_5 = null;
                        this.m_designerCoreData.restoreDefaultCursor();
                        return;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_errorReadingFile.toString(filePath, ex.getLocalizedMessage()), VWResource.s_fileOpenErrorTitle, 1);
                        this.performNewItemAction(vwStepPaletteWrapper);
                        Object var5_6 = null;
                        this.m_designerCoreData.restoreDefaultCursor();
                        return;
                    }
                }
                this.m_designerCoreData.restoreDefaultCursor();
                return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.m_designerCoreData.restoreDefaultCursor();
                throw throwable;
            }
        }
        Object var5_4 = null;
        this.m_designerCoreData.restoreDefaultCursor();
    }

    private boolean tryToSaveStepPalette(VWStepPaletteWrapper vwStepPaletteWrapper) {
        boolean bContinue = true;
        try {
            if (this.m_designerCoreData.getSessionInfo().getCanSaveToDMS()) {
                VWIDMLocalSaveOptionDialog saveDlg;
                if (vwStepPaletteWrapper.checkInOrCancelCheckOut(this.m_designerCoreData.getParentFrame(), VWResource.s_cancelCheckout) && vwStepPaletteWrapper.isDirty() && (saveDlg = new VWIDMLocalSaveOptionDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_mainWindowTitle, 1, false, false)) != null) {
                    saveDlg.setSize(DIM_SAVE_DIALOG);
                    saveDlg.setVisible(true);
                    int nReply = saveDlg.getStatus();
                    if (nReply == 8) {
                        switch (saveDlg.getChoice()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                return this.performFnAddItemAction(vwStepPaletteWrapper);
                            }
                            case 2: {
                                return this.performSaveItemAction(vwStepPaletteWrapper);
                            }
                        }
                    } else {
                        bContinue = nReply != 4;
                    }
                }
            } else if (vwStepPaletteWrapper.isDirty()) {
                int nConfirmResult = JOptionPane.showConfirmDialog(this.m_designerCoreData.getParentFrame(), VWResource.s_saveChangesQuestion);
                if (nConfirmResult == 0) {
                    this.performSaveItemAction(vwStepPaletteWrapper);
                } else {
                    bContinue = nConfirmResult != 2;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileSaveErrorTitle, 1);
            bContinue = false;
        }
        return bContinue;
    }

    private boolean saveStepPaletteToLocalFile(VWStepPaletteWrapper vwStepPaletteWrapper) {
        try {
            String filePath = this.m_saveFileDialog.getDirectory() + this.m_saveFileDialog.getFile();
            vwStepPaletteWrapper.saveStepPaletteToFile(filePath);
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 752, vwStepPaletteWrapper);
            this.m_openFileDialog.setDirectory(this.m_saveFileDialog.getDirectory());
            this.m_openFileDialog.setFile(this.m_saveFileDialog.getFile());
            if (VWStringUtils.compare(vwStepPaletteWrapper.getName(), VWResource.s_myPaletteOption) == 0) {
                this.updateSavedStepPaletteFilePath(filePath);
            }
        }
        catch (SecurityException ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileSecurityErrorTitle, 1);
            this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
            return false;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_designerCoreData.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_fileSaveErrorTitle, 1);
            this.m_saveFileDialog.setFile(VWResource.s_fileSaveFilterName);
            return false;
        }
        return true;
    }

    private String getSavedFilePath() {
        try {
            VWUserInfo userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                return (String)userInfo.getFieldValue("step_palette_mypalette_path");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private void updateSavedStepPaletteFilePath(String filePath) {
        try {
            VWUserInfo userInfo = this.m_designerCoreData.getSessionInfo().getSession().fetchCurrentUserInfo();
            if (userInfo != null) {
                userInfo.setFieldValue("step_palette_mypalette_path", filePath);
                userInfo.save();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWStepPaletteWrapper findStepPalette(String stepPaletteName) {
        if (this.m_stepPalettes == null) {
            return null;
        }
        for (int nIndex = 0; nIndex < this.m_stepPalettes.length; ++nIndex) {
            if (VWStringUtils.compare(this.m_stepPalettes[nIndex].getName(), stepPaletteName) != 0) continue;
            return this.m_stepPalettes[nIndex];
        }
        return null;
    }
}

